#ifndef DTREEVIEW_H
    #define DTREEVIEW_H

    #include "DBaseControlWin.h"
    #include <vector>
    #include "DString.h"

    namespace DWL {
		class DTreeView;

		//! Clase que controla un nodo del treeview
		class DTreeView_Nodo {
		  public: //////////////// Miembros publicos de esta clase
          //////////////////////// DObjeto
          DWL_DECLARAR_DOBJETO(TEXT("DTreeView_Nodo"), DEnum_Objeto_TreeView_Nodo);
								//
								//! Constructor por defecto
								// DTreeView_Nodo(void);
                                DTreeView_Nodo(void) : _TV(NULL), _Nodo(NULL), _ColorFondo(0), _ColorTexto(0), _Fuente(NULL) { 
								};
								//
								//! Constructor DTreeView y Nodo
								// DTreeView_Nodo(DTreeView *TV, HTREEITEM nNodo);
								DTreeView_Nodo(DTreeView *TV, HTREEITEM nNodo);
								//
  			  					//! Constructor DTreeView, Nodo y Colores
								// DTreeView_Nodo(DTreeView *TV, HTREEITEM nNodo, COLORREF nColorFondo, COLORREF nColorTexto);
								DTreeView_Nodo(DTreeView *TV, HTREEITEM nNodo, COLORREF nColorFondo, COLORREF nColorTexto);
								//
								//! Destructor vacio
								// ~DTreeView_Nodo(void);
                               ~DTreeView_Nodo(void) { };
								//
								//! Funcin para asignar el texto del nodo.
								// void AsignarTexto(DString &nTexto);
		    void                AsignarTexto(DString &nTexto);
								//
								//! Funcin para obtener el texto del nodo.
								// void ObtenerTexto(DString &nTexto);
		    void                ObtenerTexto(DString &nTexto);
								//
								//! Funcin para asignar el icono del nodo.
								// void Icono(const int nIcono);
		    void                Icono(const int nIcono);
								//
								//! Funcin para obtener el icono del nodo.
								// const int Icono(void);
		    const int           Icono(void);
								//
								//! Funcin para asignar el icono selecionado del nodo.
								// void IconoSeleccionado(const int nIcono);
		    void                IconoSeleccionado(const int nIcono);
								//
								//! Funcin para obtener el icono selecionado del nodo.
								// const int IkoSeleccionado(void);
		    const int           IconoSeleccionado(void);
								//
								//! Funcin para asignar la fuente
								// inline HFONT Fuente(void);
		    inline HFONT        Fuente(void) { 
									return _Fuente; 
								};
								//
								//! Funcin para obtener la fuente
								// inline void Fuente(HFONT nFuente);
		    inline void         Fuente(HFONT nFuente) {
									_Fuente = nFuente; 
								};
								//
								//! Funcin para asignar el color del texto del nodo.
								// inline void ColorTexto(COLORREF nColor);
		    inline void         ColorTexto(COLORREF nColor) {
									_ColorTexto = nColor; 
								};
								//
								//! Funcin para obtener el color del texto del nodo.
								// inline COLORREF ColorTexto(void);
		    inline COLORREF     ColorTexto(void) {
									return _ColorTexto; 
								};
								//
								//! Funcin para asignar el color del fondo del nodo.
								// inline  void ColorFondo(COLORREF nColor);
		    inline void         ColorFondo(COLORREF nColor) {
									_ColorFondo = nColor; 
								};
								//
								//! Funcin para obtener el color del fondo del nodo.
								// inline  COLORREF ColorFondo(void);
		    inline COLORREF     ColorFondo(void) { 
									return _ColorFondo; 
								};
								//
								//! Funcin para obtener la ID unica del nodo.
								// inline  HTREEITEM hTreeItem(void);
		    inline HTREEITEM    hTreeItem(void) {
									return _Nodo; 
								};
								//
								//! Funcin para obtener un puntero de la Clase DTreeView_Nodo que apunte al nodo Hijo.
								// DTreeView_Nodo *NodoHijo(void);
		    DTreeView_Nodo     *NodoHijo(void);
								//
								//! Funcin para obtener un puntero de la Clase DTreeView_Nodo que apunte al nodo Padre.
								// DTreeView_Nodo *NodoPadre(void);
		    DTreeView_Nodo     *NodoPadre(void);
								//
								//! Funcin para obtener un puntero de la Clase DTreeView_Nodo que apunte al nodo Siguente.
								// DTreeView_Nodo *NodoSiguiente(void);
		    DTreeView_Nodo     *NodoSiguiente(void);
								//
								//! Funcin para obtener un puntero de la Clase DTreeView_Nodo que apunte al nodo Anterior.
								// DTreeView_Nodo *NodoAnterior(void);
		    DTreeView_Nodo     *NodoAnterior(void);
								//
								//! Funcin para obtener la ID unica del nodo Hijo.
								// HTREEITEM Hijo(void);
		    HTREEITEM           Hijo(void);
								//
								//! Funcin para obtener la ID unica del nodo Padre.
								// HTREEITEM Padre(void);
		    HTREEITEM           Padre(void);
								//
								//! Funcin para obtener la ID unica del nodo Siguiente.
								// HTREEITEM Siguiente(void);
		    HTREEITEM           Siguiente(void);
								//
								//! Funcin para obtener la ID unica del nodo Anterior.
								// HREEITEM Anterior(void);
		    HTREEITEM           Anterior(void);
								//
								//! Funcin para selecionar el Nodo en el TreeView.
								// void Seleccionar(void);
		    void                Seleccionar(void);
								//
								//! Funcin para que se muestre este nodo en concreto
								// void HacerVisible(void);
		    void                HacerVisible(void);
		  protected: ///////////// Miembros protegidos de esta clase
								//
								//! Funcin para asignar los miembros basicos de esta clase (Esta Funcin es de uso interno para asignar clases derivadas)
								// void _AsignarBase(DTreeView *TV, HTREEITEM nNodo, COLORREF nColorFondo, COLORREF nColorTexto);
		    void               _AsignarBase(DTreeView *TV, HTREEITEM nNodo, COLORREF nColorFondo, COLORREF nColorTexto);
								//
								//! Funcin para asignar los miembros basicos de esta clase (Esta Funcin es de uso interno para asignar clases derivadas)
								// void _AsignarBase(DTreeView *TV, HTREEITEM nNodo);
		    void               _AsignarBase(DTreeView *TV, HTREEITEM nNodo);
								//
								//! ID unica de este nodo
		    HTREEITEM          _Nodo;
								//
								//! Color del fondo de este nodo
		    COLORREF           _ColorFondo;
								//
								//! Color del texto de este nodo
		    COLORREF           _ColorTexto;
								//
								//! Fuente de este nodo
		    HFONT              _Fuente;
								//
								//! Puntero de la DTreeView de donde sale este nodo
		    DTreeView         *_TV;
		    friend class DTreeView; // Declaro la clase DTreeView amiga de esta clase
		};
        



		//! Clase que controla un TreeView de windows
        class DTreeView : public DBaseControlWin {
		  public: //////////////////////////////// Miembros publicos de esta clase
          //////////////////////////////////////// DObjeto
          DWL_DECLARAR_DOBJETO(TEXT("DTreeView"), DEnum_Objeto_TreeView);
											    //
											    //! Constructor.
											    //  DTreeView(void);
											    DTreeView(void);
											    //
											    //! Destructor.
											    // ~DTreeView(void);
										       ~DTreeView(void);
											    //
											    //! Funcin para crear el TreeView.
											    //  HWND Crear(DWORD Estilos, HWND hWndPadre, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, DWORD EstilosExtendidos = NULL);
		    virtual HWND					    Crear(DBaseWnd *nPadre, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, DWORD nEstilos, DWORD nEstilosExtendidos = NULL);
											    //
											    //! Funcin para asignar esta clase a un TreeView creado anteriormente en el editor de recursos.
											    //  void Asignar(HWND hWndPadre, const UINT cID);
		    virtual void						Asignar(DBaseWnd *nPadre, const UINT cID);
											    //
											    //! Funcin para Agregar un Nodo partiendo de una clase derivada de DTreeView_Nodo.
											    //  HTREEITEM AgregarNodo(DTreeView_Nodo *Nodo, HTREEITEM Parent, const TCHAR *cTexto, const int cIko, HTREEITEM InsertarDespuesDe = NULL);
     		HTREEITEM							AgregarNodo(DTreeView_Nodo *nNodo, HTREEITEM Parent, const TCHAR *cTexto, const int cIko, HTREEITEM InsertarDespuesDe = NULL);
											    //
											    //! Funcin para Agregar un Nodo partiendo de una clase derivada de DTreeView_Nodo con sus colores.
											    //  HTREEITEM AgregarNodo(DTreeView_Nodo *Nodo, HTREEITEM Parent, const TCHAR *cTexto, const int cIko, COLORREF nColorTexto, COLORREF nColorFondo, HTREEITEM InsertarDespuesDe = NULL);
		    HTREEITEM							AgregarNodo(DTreeView_Nodo *nNodo, HTREEITEM Parent, const TCHAR *cTexto, const int cIko, COLORREF nColorTexto, COLORREF nColorFondo, HTREEITEM InsertarDespuesDe = NULL);
											    //
											    //! Funcin para Agregar un Nodo normal.
											    //  HTREEITEM AgregarNodo(HTREEITEM Parent, const TCHAR *cTexto, const int cIko, HTREEITEM InsertarDespuesDe = NULL);
		    HTREEITEM							AgregarNodo(HTREEITEM Parent, const TCHAR *cTexto, const int cIko, HTREEITEM InsertarDespuesDe = NULL);
											    //
											    //! Funcin para Agregar un Nodo normal especificando sus colores.
											    //  HTREEITEM AgregarNodo(HTREEITEM Parent, const TCHAR *cTexto, const int cIko, COLORREF nColorTexto, COLORREF nColorFondo, HTREEITEM InsertarDespuesDe = NULL);
		    HTREEITEM							AgregarNodo(HTREEITEM Parent, const TCHAR *cTexto, const int cIko, COLORREF nColorTexto, COLORREF nColorFondo, HTREEITEM InsertarDespuesDe = NULL);
											    //
											    //! Funcin para borrar un nodo por su ID
											    //  void BorrarNodo(HTREEITEM BNodo);
		    void								BorrarNodo(HTREEITEM BNodo);
											    //
											    //! Funcin para borrar un nodo por su posicion
											    //  void BorrarNodo(const unsigned int Pos);
		    void								BorrarNodo(const unsigned int Pos);
											    //
											    //! Funcin para borrar todos los nodos
											    //  void BorrarTodo(void);
		    void								BorrarTodo(void);
											    //
											    //! Funcin para asignar la selecion.
											    //  inline void Seleccion(HTREEITEM sNodo);
		    inline void						    Seleccion(HTREEITEM sNodo) { 
												    TreeView_SelectItem(_hWnd, sNodo); 
											    };
											    //
											    //! Funcin para obtener la selecion.
											    //  inline HTREEITEM Seleccion(void);
		    inline HTREEITEM					Seleccion(void) { 
												    return TreeView_GetSelection(_hWnd); 
											    };
											    //
											    //! Funcin que retorna un puntero DTreeView_Nodo partiendo de la ID Unica especificada.
											    //  DTreeView_Nodo *BuscarNodo(HTREEITEM BNodo);
		    DTreeView_Nodo                     *BuscarNodo(HTREEITEM BNodo);
											    //
											    //! Funcin para asignar el color del texto.
											    //  Para utilizar el color del sistema seleccionado utilizar -1 como color / parametro
											    //  inline void ColorTexto(COLORREF Col);
		    inline void						    ColorTexto(COLORREF Col) { 
												    TreeView_SetTextColor(_hWnd, Col); 
											    };
											    //
											    //! Funcin para obtener el color del texto.
											    //  inline COLORREF ColorTexto(void);
		    inline COLORREF				        ColorTexto(void) {
												    return TreeView_GetTextColor(_hWnd); 
											    };
											    //
											    //! Funcin para asignar el color del fondo.
											    //  Para utilizar el color del sistema seleccionado utilizar -1 como color / parametro
											    //  inline void ColorFondo(COLORREF Col);
		    inline void						    ColorFondo(COLORREF Col) {
												    TreeView_SetBkColor(_hWnd, Col); 
											    };
											    //
											    //! Funcin para obtener el color del fondo.
											    //  inline COLORREF ColorFondo(void);
		    inline COLORREF					    ColorFondo(void) { 
												     return TreeView_GetBkColor(_hWnd); 
											    };
											    //
											    //! Funcin para asignar el color del fondo del nodo selecionado.
											    //  inline void ColorFondoSeleccionado(COLORREF Col);
/*		    inline void						    ColorFondoSeleccionado(COLORREF Col) {
												    _ColorSeleccion = Col; 
											    };
											    //
											    //! Funcin para obtener el color del fondo del nodo selecionado.
											    //  inline COLORREF ColorFondoSeleccionado(void);
		    inline COLORREF					    ColorFondoSeleccionado(void) { 
												    return _ColorSeleccion; 
											    };
											    //
											    //! Funcin para asignar el color del texto del nodo selecionado.
											    //  inline void ColorTextoSeleccionado(COLORREF Col);
		    inline void					        ColorTextoSeleccionado(COLORREF Col) {
												    _ColorSeleccionTexto = Col; 
											    };
											    //
											    //! Funcin para obtener el color del texto del nodo selecionado.
											    //  inline COLORREF ColorTextoSeleccionado(void);
		    inline COLORREF					    ColorTextoSeleccionado(void) {
												    return _ColorSeleccionTexto; 
											    };*/
											    //
											    //! Funcin para obtener la ID Unica del Nodo que esta en las coordenadas especificadas.
											    //  HTREEITEM HitTest(const int cX, const int cY);
		    HTREEITEM							HitTest(const int cX, const int cY);
											    //
											    //! Funcin para obtener la ID Unica del Nodo que esta en bajo el mouse.
											    //  HTREEITEM HitTest(void);
		    HTREEITEM							HitTest(void);
											    //
											    //! Funcin que retorna el Nodo especificado en forma de Clase DTreeView_Nodo. 
											    //  DTreeView_Nodo *Nodo(const UINT Pos);
		    DTreeView_Nodo		               *Nodo(const UINT Pos);
											    //
											    //! Funcin que retorna el Numero total de Nodos en el TreeView.
											    //  const UINT TotalNodos(void);
		    inline UINT             			TotalNodos(void) const {
												    return static_cast<UINT>(_Nodos.size()); 
											    };
											    //
											    //! Funcin para asignar un ImageList al TreeView
											    //  inline void AsignarImageList(HIMAGELIST ImgList);
		    inline void						    AsignarImageList(HIMAGELIST ImgList) {
												    TreeView_SetImageList(_hWnd, ImgList, TVSIL_NORMAL); 
											    };
											    //
											    //! Funcin para obtener la fuente
											    //  inline HFONT Fuente(void);
    		inline HFONT						Fuente(void) {
												    return _Fuente; 
											    };
											    //
											    //! Funcin para asignar la fuente
											    //  inline void Fuente(HFONT nFuente);
		    inline void						    Fuente(HFONT nFuente) {
												    if (nFuente != NULL) _Fuente = nFuente; 
											    };
											    // 
											    //! Funcin para empezar la edicion de un nodo del arbol
											    //  HWND EmpezarLabelEdit(DTreeView_Nodo *nNodo, const bool Numerico = false);
    		HWND								EmpezarLabelEdit(DTreeView_Nodo *nNodo, const bool Numerico = false);
											    // 
											    //! Funcin que termina la edicion de un nodo
											    //  void TerminarLabelEdit(void);
		    void								TerminarLabelEdit(void);
											    // 
											    //! Funcin que cancela la edicion de un nodo
											    //  void CancelarLabelEdit(void);
		    void								CancelarLabelEdit(void);
											    //
											    //! Funcin para mostrar un item
											    //  inline void MostrarNodo(HTREEITEM mNodo);
		    inline void					        MostrarNodo(HTREEITEM mNodo) {
												    TreeView_EnsureVisible(_hWnd, mNodo); 
											    };
                                                //
                                                //! Evento que es llamado cuando se expande / contrae un nodo del treeview
                                                //  virtual void TreeView_Evento_Nodo_Expandiendo(DTreeView_Nodo *nNodo);
            virtual void                        TreeView_Evento_Nodo_Expandiendo(DTreeView_Nodo *nNodo) { };
											    //
											    //! Funcin para llamar al WindowProcedure original del TreeView. 
                                                //  LRESULT CALLBACK GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
		    LRESULT CALLBACK		            GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
                                                //! Funcin que devuelve que tipo de clase BaseWnd es esta clase
                                                /*! Esta funcin devuelve que tipo de clase BaseWnd es esta clase
                                                        \fn         virtual const DEnum_TipoBaseWnd TipoBaseWnd(void);
                                                        \returns    Devuelve un valor de DEnum_TipoBaseWnd
                                                        \remars     Esta funcin identifica que tipo de ventana o control se esta utilizando.
                                                */
            virtual const DEnum_TipoBaseWnd     TipoBaseWnd(void)   { return DEnum_TipoBaseWnd_TreeView; };
		  protected : //////////////////////////// Declaraciones protegidas (Solo podran usarse en la clase heredada no desde fuera)
											    //
											    //! Fuente por defecto del control
		    HFONT					           _Fuente;
											    //
											    //! Funcin que se encarga de especificar los colores y la Fuente del TreeView para cada nodo
		    LRESULT				               _CustomDraw(LPARAM Datos);
											    //
										        //! Funcin para asignar si el nodo tiene hijos o no..
		    void				               _SetChildren(HTREEITEM IC, const bool TieneHijos);
											    //
											    //! Color para el Fondo del Nodo selecionado
//		    COLORREF			               _ColorSeleccion;
											    //
											    //! Color para el Texto del Nodo selecionado
//		    COLORREF                           _ColorSeleccionTexto;
											    //
											    //! Vector que contiene los Nodos
		    std::vector<DTreeView_Nodo *>      _Nodos;
                                                //
                                                //! Ultima posicion X del mouse al presoinar un boton (necesario para simular el WM_LBUTTONUP)
            int                                _uX;
                                                //
                                                //! Ultima posicion Y del mouse al presoinar un boton (necesario para simular el WM_LBUTTONUP)
            int                                _uY;
  		   private: ////////////////////////////// Miembros privados
		   /////////////////////////////////////// -Miembros usados en el LabelEdit-
											    //
											    //! WindowProcedure que usara el Editbox en la Funcin EmpezarLabelEdit
											    // static LRESULT CALLBACK _GestorMensajesEdit(HWND dhWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
		    static LRESULT CALLBACK            _GestorMensajesEdit(HWND dhWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
											    //
											    //! Nodo en edicion
		    DTreeView_Nodo		              *_eNodo;
											    //
											    //! WindowProcedure Original del EditBox
		    WNDPROC						       _GestorMensajesOriginalEdit;
											    //
											    //! Brocha del fondo del EditBox
		    HBRUSH					           _BrochaFondoEdit;
											    //
											    //! Valor para saber si la lista esta en estado de edicion
		    bool			                   _Editando;
											    //
											    //! Handle del EditBox
		    HWND						       _hWndEdit;
											    //
		    friend class DTreeView_Nodo;        // Decalro la clase DTreeView_Nodo amiga de esta clase
		};									    //
		////////////////////////////////////////// Fin class DTreeView;




		//! Clase contenedora de los datos que se pueden necesitar al terminar la edicion de un nodo
		class DTreeView_TerminarLabelEdit {
		  public : /////////////////// Miembros publicos
          //////////////////////////// DObjeto
          DWL_DECLARAR_DOBJETO(TEXT("DTreeView_TerminarLabelEdit"), DEnum_Objeto_TreeView_TerminarLabelEdit);
									//
									//! Constructor por defecto (Nunca deberia usarse)
									// DTreeView_TerminarLabelEdit(void);
									DTreeView_TerminarLabelEdit(void) {
										Cancelar = false;
									};
									//
									//! Constructor asignador de datos
									// DTreeView_TerminarLabelEdit(DTreeView_Nodo *nNodo, const TCHAR *nNuevoTexto);
									DTreeView_TerminarLabelEdit(DTreeView_Nodo *nNodo, const TCHAR *nNuevoTexto) {
										Cancelar = false;
										_Nodo = nNodo;
										NuevoTexto = nNuevoTexto;
									};
									//
									//! Destructor
									// ~DTreeView_TerminarLabelEdit(void);
								   ~DTreeView_TerminarLabelEdit(void) {
									};
									//
									//! Funcin que retorna un puntero al DTreeView_Nodo correspondiente a este nodo en edicion.
									// inline DTreeView_Nodo *Nodo(void);
		    inline DTreeView_Nodo  *Nodo(void) {
										return _Nodo;
									};
									//
									//! Estado de cancelacion para esta edicion
		    bool				    Cancelar;
									//
									//! Nuevo texto que se va a aplicar
		    DString		        	NuevoTexto;
		  private : ////////////////// Miembros privados
									//
									//! Clase DTreeView_Nodo que contiene el nodo que se esta editando
		    DTreeView_Nodo        *_Nodo;
		};							//
		//////////////////////////////

    };

#endif